/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HardwareServerUtilities;
import com.ibm.hsc.common.util.HexDump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class PIHypIPCfg {
    private Socket m_hdwr_svrSocket;
    private InputStream m_socketInput;
    private DataOutputStream m_socketOutput;
    private int m_hsCorrToken = 1;
    private static final int NONE = 0;
    private static final int LISTIP = 1;
    private static final int ADDIP = 2;
    private static final int REMOVEIP = 3;
    private static final int ACTIVATEIP = 4;
    private static final int DEACTIVATEIP = 5;
    private static final int LISTPCISLOTS = 6;
    private static final int LISTCECS = 7;
    private static final int SETPCISLOTOWNER = 8;
    private static final int INIT_PHYP_PASSTHROUGH = 9;
    private static final int GETTAGS = 10;
    private static final int SETTAGS = 11;
    public static final int SPEED_AUTO = 0;
    public static final String SPEED_AUTO_STR = "AUTO";
    public static final int SPEED_4 = 1;
    public static final String SPEED_4_STR = "4";
    public static final int SPEED_10 = 2;
    public static final String SPEED_10_STR = "10";
    public static final int SPEED_16 = 3;
    public static final String SPEED_16_STR = "16";
    public static final int SPEED_100 = 4;
    public static final String SPEED_100_STR = "100";
    public static final int SPEED_1000 = 5;
    public static final String SPEED_1000_STR = "1000";
    public static final int DUPLEX_AUTO = 0;
    public static final String DUPLEX_AUTO_STR = "AUTO";
    public static final int DUPLEX_HALF = 1;
    public static final String DUPLEX_HALF_STR = "HALF";
    public static final int DUPLEX_FULL = 2;
    public static final String DUPLEX_FULL_STR = "FULL";
    public static final int STATE_DOWN = 0;
    public static final String STATE_DOWN_STR = "DOWN";
    public static final int STATE_UP = 1;
    public static final String STATE_UP_STR = "UP";
    public static final int STATE_UNKNOWN = 255;
    public static final String STATE_UNKNOWN_STR = "UNKNOWN";

    public static String IPAddrToString(int n) {
        return "" + (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
    }

    public static int StringToIPAddr(String string) {
        int n = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 4) {
                System.out.println("Count tokens: " + stringTokenizer.countTokens());
                return 0;
            }
            while (stringTokenizer.hasMoreTokens()) {
                n = n << 8 | Integer.parseInt(stringTokenizer.nextToken()) & 0xFF;
            }
        }
        catch (Exception exception) {
            System.err.println("StringToIPAddrError parseing '" + string + "' : " + exception);
            exception.printStackTrace(System.err);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        HypIpConfigInfo hypIpConfigInfo = null;
        int[] nArray = null;
        if (stringArray.length == 0) {
            PIHypIPCfg.printHelp(null);
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            System.out.println("args[" + i + "] = '" + stringArray[i] + "'");
            if ("-hwsip".equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= stringArray.length) {
                    PIHypIPCfg.printHelp("Error: -hwsip needs a parm");
                }
                string = stringArray[++i];
                continue;
            }
            if ("-vport".equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= stringArray.length) {
                    PIHypIPCfg.printHelp("Error: -vport needs a parm");
                }
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if ("-listip".equalsIgnoreCase(stringArray[i])) {
                n = 1;
                continue;
            }
            if ("-addip".equalsIgnoreCase(stringArray[i])) {
                n = 2;
                System.out.println("al = " + stringArray.length + " i = " + i);
                if (i + 8 >= stringArray.length) {
                    PIHypIPCfg.printHelp("Error: not enough arguments for -add.");
                }
                string2 = stringArray[++i];
                object = new int[8];
                try {
                    object[0] = (int)(Long.parseLong(string2, 16) & 0xFFFFFFFFFFFFFFFFL);
                }
                catch (Exception exception) {
                    PIHypIPCfg.printHelp("Error: Invalid drc index '" + string2 + "'");
                }
                try {
                    object[1] = PIHypIPCfg.StringToIPAddr(stringArray[++i]);
                    object[2] = PIHypIPCfg.StringToIPAddr(stringArray[++i]);
                    object[3] = PIHypIPCfg.StringToIPAddr(stringArray[++i]);
                    object[4] = PIHypIPCfg.StringToIPAddr(stringArray[++i]);
                    if (object[1] == 0 || object[2] == 0 || object[3] == 0 || object[4] == 0) {
                        PIHypIPCfg.printHelp("Error: Invalid ip address.");
                    }
                }
                catch (Exception exception) {
                    PIHypIPCfg.printHelp("Error: Invalid ip address.");
                    System.out.println("IP address parse exception: " + exception);
                    exception.printStackTrace();
                }
                String string3 = stringArray[++i];
                if ("AUTO".equalsIgnoreCase(string3)) {
                    object[5] = 0;
                } else if (SPEED_4_STR.equalsIgnoreCase(string3)) {
                    object[5] = 1;
                } else if (SPEED_10_STR.equalsIgnoreCase(string3)) {
                    object[5] = 2;
                } else if (SPEED_16_STR.equalsIgnoreCase(string3)) {
                    object[5] = 3;
                } else if (SPEED_100_STR.equalsIgnoreCase(string3)) {
                    object[5] = 4;
                } else {
                    PIHypIPCfg.printHelp("The speed parm '" + string3 + "' is invalid.");
                }
                String string4 = stringArray[++i];
                if ("AUTO".equalsIgnoreCase(string4)) {
                    object[6] = 0;
                } else if (DUPLEX_FULL_STR.equalsIgnoreCase(string4)) {
                    object[6] = 2;
                } else if (DUPLEX_HALF_STR.equalsIgnoreCase(string4)) {
                    object[6] = 1;
                } else {
                    PIHypIPCfg.printHelp("The duplex parm '" + string4 + "' is invalid.");
                }
                String string5 = stringArray[++i];
                if (STATE_UNKNOWN_STR.equalsIgnoreCase(string5)) {
                    object[7] = 255;
                } else if (STATE_DOWN_STR.equalsIgnoreCase(string5)) {
                    object[7] = 0;
                } else if (STATE_UP_STR.equalsIgnoreCase(string5)) {
                    object[7] = 1;
                } else {
                    PIHypIPCfg.printHelp("The state parm '" + string5 + "' is invalid.");
                }
                hypIpConfigInfo = new HypIpConfigInfo(object[0], object[1], object[2], object[3], object[4], object[5], object[6], object[7]);
                continue;
            }
            if ("-removeip".equalsIgnoreCase(stringArray[i])) {
                n = 3;
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if ("-activateip".equalsIgnoreCase(stringArray[i])) {
                n = 4;
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if ("-deactivateip".equalsIgnoreCase(stringArray[i])) {
                n = 5;
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if ("-buslist".equalsIgnoreCase(stringArray[i])) {
                n = 6;
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if ("-listcecs".equalsIgnoreCase(stringArray[i])) {
                n = 7;
                continue;
            }
            if ("-assignslot".equalsIgnoreCase(stringArray[i])) {
                n = 8;
                if (i + 2 >= stringArray.length) {
                    PIHypIPCfg.printHelp("Error: not enough arguments for -assignslot.");
                }
                string2 = stringArray[++i];
                if ("NONE".equalsIgnoreCase((String)(object = (Object)stringArray[++i]))) {
                    n3 = 65535;
                    continue;
                }
                try {
                    n3 = Integer.parseInt((String)object) & 0xFFFF;
                }
                catch (Exception exception) {
                    PIHypIPCfg.printHelp("Error: Invalid partition id '" + (String)object + "'");
                }
                continue;
            }
            if ("-inithyp".equalsIgnoreCase(stringArray[i])) {
                n = 9;
                continue;
            }
            if ("-gettags".equalsIgnoreCase(stringArray[i])) {
                n = 10;
                if (i + 1 >= stringArray.length) {
                    PIHypIPCfg.printHelp("Error: not enough arguments for -gettags.");
                }
                if ("NONE".equalsIgnoreCase((String)(object = (Object)stringArray[++i]))) {
                    n3 = 65535;
                    continue;
                }
                try {
                    n3 = Integer.parseInt((String)object) & 0xFFFF;
                }
                catch (Exception exception) {
                    PIHypIPCfg.printHelp("Error: Invalid partition id '" + (String)object + "'");
                }
                continue;
            }
            if (!"-setconsoletag".equalsIgnoreCase(stringArray[i])) continue;
            n = 11;
            if (i + 2 >= stringArray.length) {
                PIHypIPCfg.printHelp("Error: not enough arguments for -assignslot.");
            }
            string2 = stringArray[++i];
            object = stringArray[++i];
            nArray = new int[5];
            for (int j = 0; j < 5; ++j) {
                nArray[j] = 553713699;
            }
            if ("NONE".equalsIgnoreCase(string2)) {
                n3 = 65535;
            } else {
                try {
                    n3 = Integer.parseInt((String)object) & 0xFFFF;
                }
                catch (Exception exception) {
                    PIHypIPCfg.printHelp("Error: Invalid partition id '" + (String)object + "'");
                }
            }
            try {
                nArray[2] = (int)(Long.parseLong(string2, 16) & 0xFFFFFFFFFFFFFFFFL);
                continue;
            }
            catch (Exception exception) {
                PIHypIPCfg.printHelp("Error: Invalid drcindex '" + string2 + "'");
            }
        }
        if (n2 <= 0 && n != 7) {
            PIHypIPCfg.printHelp("Error: valid vport not selected.");
        }
        try {
            PIHypIPCfg pIHypIPCfg = new PIHypIPCfg(string);
            int n4 = 0;
            if (string2 != null) {
                n4 = (int)(Long.parseLong(string2, 16) & 0xFFFFFFFFFFFFFFFFL);
            }
            switch (n) {
                case 1: {
                    HypIpConfigInfo[] hypIpConfigInfoArray = pIHypIPCfg.list(n2);
                    if (hypIpConfigInfoArray == null || hypIpConfigInfoArray.length == 0) {
                        System.out.println("No hyp IP interfaces defined.");
                        break;
                    }
                    for (int i = 0; i < hypIpConfigInfoArray.length; ++i) {
                        System.out.println("IFC[" + i + "] " + hypIpConfigInfoArray[i].toString());
                    }
                    break;
                }
                case 2: {
                    if (hypIpConfigInfo == null) {
                        PIHypIPCfg.printHelp("Unexpected error: newIpCfgInfo is null");
                    }
                    pIHypIPCfg.add(n2, hypIpConfigInfo);
                    break;
                }
                case 3: {
                    pIHypIPCfg.remove(n2, n4);
                    break;
                }
                case 4: {
                    pIHypIPCfg.setActivationState(n2, n4, 1);
                    break;
                }
                case 5: {
                    pIHypIPCfg.setActivationState(n2, n4, 0);
                    break;
                }
                case 6: {
                    int n5 = (int)(Long.parseLong(string2, 10) & 0xFFFFFFFFFFFFFFFFL);
                    pIHypIPCfg.printBusInfo(n2, n5);
                    break;
                }
                case 7: {
                    pIHypIPCfg.listCECs();
                    break;
                }
                case 8: {
                    if (n4 != 0 && n3 != -1) {
                        pIHypIPCfg.setSlotOwner(n2, n4, n3);
                        break;
                    }
                    PIHypIPCfg.printHelp("Error: invalid drc or partitionid");
                    break;
                }
                case 9: {
                    pIHypIPCfg.initPhypPassthrough(n2);
                    break;
                }
                case 10: {
                    pIHypIPCfg.getTaggedIO(n2, n3);
                    break;
                }
                case 11: {
                    pIHypIPCfg.setTaggedIO(n2, n3, nArray);
                    break;
                }
                default: {
                    PIHypIPCfg.printHelp("Error: no action selected.");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("PIHypIPCfg main IOException: " + iOException);
            iOException.printStackTrace();
        }
        System.out.println("done");
        System.exit(0);
    }

    private static void printHelp(String string) {
        if (string != null) {
            System.out.println("******************************************************");
            System.out.println("* " + string);
            System.out.println("******************************************************");
        }
        System.out.println("Usage: PIHypIPCfg");
        System.out.println("  -hwsip hwsipaddr");
        System.out.println("     hwsipaddr = the ip of the HMC hardware server (default is localhost)");
        System.out.println("  -vport port");
        System.out.println("     port = vport of target cec (required for all opts except -listcecs)\n");
        System.out.println("  [-listcecs]");
        System.out.println("      get a list of fsps with vport and mtms");
        System.out.println("  [-inithyp]");
        System.out.println("      this must be done once per PHYP IPL or the other cmds will not work");
        System.out.println("  [-buslist busid]");
        System.out.println("  [-assignslot hexdrc partitionid");
        System.out.println("     hexdrc = the drcindex in hexadecimal format");
        System.out.println("     partitionid = the new owning partitionid in decimal format or 'NONE'");
        System.out.println("  [-listip]");
        System.out.println("  [-addip hexdrc ip mask gw1 gw2 speed duplex state]");
        System.out.println("     ip = the ip address in dotted notation (ex. 10.10.10.10)");
        System.out.println("     mask = the subnet mask in dotted notation (ex. 255.255.255.0)");
        System.out.println("     gw1 = the first gateway in dotted notation (ex. 10.10.10.1)");
        System.out.println("     gw2 = the second gateway");
        System.out.println("     speed = interface speed [Auto, 4, 10, 16, 100, 1000]");
        System.out.println("     duplex = interface duplex [Auto, Half, Full]");
        System.out.println("     state  = initial interface state [Down, Up]");
        System.out.println("  [-removeip hexdrc]");
        System.out.println("  [-activateip hexdrc]");
        System.out.println("  [-deactivateip hexdrc]");
        if (string != null) {
            System.out.println("******************************************************");
            System.out.println("* " + string);
            System.out.println("******************************************************");
        }
        System.exit(1);
    }

    public PIHypIPCfg(String string) throws IOException {
        this.m_hdwr_svrSocket = new Socket(string, 8877);
        this.m_socketInput = this.m_hdwr_svrSocket.getInputStream();
        this.m_socketOutput = new DataOutputStream(this.m_hdwr_svrSocket.getOutputStream());
    }

    public HypIpConfigInfo[] list(int n) throws IOException {
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 3329, null);
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 24, byArray.length - 24);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n2 = dataInputStream.readInt();
        HypIpConfigInfo[] hypIpConfigInfoArray = new HypIpConfigInfo[n2];
        for (int i = 0; i < n2; ++i) {
            hypIpConfigInfoArray[i] = new HypIpConfigInfo(dataInputStream);
        }
        return hypIpConfigInfoArray;
    }

    public void add(int n, HypIpConfigInfo hypIpConfigInfo) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        hypIpConfigInfo.writeToDataOutputStream(dataOutputStream);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 36098, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
    }

    public void remove(int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n2);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 36099, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
    }

    public void setActivationState(int n, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(n3);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(0);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 36100, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
    }

    public void printIOInfo(int n) throws IOException {
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 1289, null);
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
        if (byArray != null) {
            int n2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 24, byArray.length - 24);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = dataInputStream.readShort();
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = dataInputStream.readShort();
                System.out.println("BusId found: " + nArray[n2]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                System.out.println("Info for bus: " + nArray[n2]);
                this.printBusInfo(n, nArray[n2]);
            }
        }
    }

    public void printBusInfo(int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(10);
        dataOutputStream.writeInt(0);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 1284, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 24, byArray.length - 24);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = dataInputStream.readShort();
            dataInputStream.readShort();
            if (n3 == 0) {
                System.out.println("bus " + n2 + " does not have any slots.");
            } else {
                System.out.println("Listing slots for bus number " + n2);
            }
            for (int i = 0; i < n3; ++i) {
                int n4 = dataInputStream.readShort() & 0xFFFF;
                int n5 = dataInputStream.readShort() & 0xFFFF;
                dataInputStream.readShort();
                dataInputStream.readShort();
                byte[] byArray2 = new byte[4];
                dataInputStream.read(byArray2);
                String string = "???";
                try {
                    string = new String(byArray2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dataInputStream.readShort();
                dataInputStream.readShort();
                dataInputStream.readShort();
                dataInputStream.readShort();
                int n6 = dataInputStream.readByte() & 0xFF;
                int n7 = dataInputStream.readByte() & 0xFF;
                dataInputStream.readShort();
                int n8 = dataInputStream.readInt();
                dataInputStream.readInt();
                dataInputStream.readInt();
                String string2 = null;
                if (n6 == 2) {
                    switch (n7) {
                        case 0: {
                            string2 = "Ethernet";
                            break;
                        }
                        case 1: {
                            string2 = "Token Ring";
                            break;
                        }
                        default: {
                            string2 = "Network controller";
                        }
                    }
                }
                System.out.print("  slot[" + i + "] owner(c,p):" + (n4 == 65535 ? "NONE" : Integer.toString(n4)) + ", " + (n5 == 65535 ? "NONE" : Integer.toString(n5)) + " location:" + string + " pciclass:" + Integer.toHexString(n6) + "," + Integer.toHexString(n7) + " drc:" + Integer.toHexString(n8));
                if (string2 == null) {
                    System.out.println("");
                    continue;
                }
                System.out.println("  pciLookup = " + string2);
            }
        }
    }

    public void setSlotOwner(int n, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(65535);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 34052, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
    }

    public void listCECs() throws IOException {
        int n;
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildHSFspQuery();
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        if (hardwareServerMessage2.isHSError()) {
            System.err.println("HS Response RC = 0x" + Integer.toHexString(hardwareServerMessage2.getErrorCode()));
            System.err.println("HS Response: " + hardwareServerMessage2.toString());
            return;
        }
        byte[] byArray = hardwareServerMessage2.getPayload();
        int[] nArray = new int[byArray.length / 4];
        if (nArray.length == 0) {
            System.out.println("No hardware server managed fsps were found.");
            return;
        }
        System.out.print("found " + nArray.length + " vport(s)");
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = HardwareServerMessage.bytesToUInt(byArray, n * 4);
        }
        System.out.println("");
        for (n = 0; n < nArray.length; ++n) {
            hardwareServerMessage = HardwareServerMessage.buildFspDataQuery(nArray[n]);
            hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
            if (hardwareServerMessage2.isHSError()) {
                System.err.println("HS Response RC = 0x" + Integer.toHexString(hardwareServerMessage2.getErrorCode()));
                System.err.println("HS Response: " + hardwareServerMessage2.toString());
                return;
            }
            byArray = hardwareServerMessage2.getPayload();
            int n2 = HardwareServerMessage.bytesToUShort(byArray, 0);
            String string = null;
            for (int i = n2; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                string = new String(byArray, n2, i - n2);
                break;
            }
            System.out.print("vport[" + nArray[n] + "] mtms: ");
            System.out.println(string == null ? "not found" : string);
        }
    }

    private void initPhypPassthrough(int n) throws IOException {
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 5, 10, null);
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
    }

    private void getTaggedIO(int n, int n2) throws IOException {
        System.out.println("Tagged IO for ptn " + n2 + " and vport " + n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n2);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 1285, byteArrayOutputStream.toByteArray());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
        System.out.println("response = " + hardwareServerMessage2.toString());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 24, byArray.length - 24);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        System.out.println("        LS: " + Integer.toHexString(dataInputStream.readInt()));
        System.out.println("       ALS: " + Integer.toHexString(dataInputStream.readInt()));
        System.out.println("       Con: " + Integer.toHexString(dataInputStream.readInt()));
        System.out.println("      ACon: " + Integer.toHexString(dataInputStream.readInt()));
        System.out.println("       ECS: " + Integer.toHexString(dataInputStream.readInt()));
        System.out.println("Recent ALS: " + Integer.toHexString(dataInputStream.readInt()));
    }

    private void setTaggedIO(int n, int n2, int[] nArray) throws IOException {
        System.out.println("Set Tagged IO for ptn " + n2 + " and vport " + n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(0);
        for (int i = 0; i < 5; ++i) {
            System.out.println("drclist[" + i + "] = " + Integer.toHexString(nArray[i]));
            dataOutputStream.writeInt(nArray[i]);
        }
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(n, 32769, 34053, byteArrayOutputStream.toByteArray());
        System.out.println("outbound msg = " + hardwareServerMessage.toString());
        HardwareServerMessage hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
        byte[] byArray = this.parseHwsResponse(hardwareServerMessage2);
        System.out.println("response = " + hardwareServerMessage2.toString());
    }

    private byte[] parseHwsResponse(HardwareServerMessage hardwareServerMessage) {
        if (hardwareServerMessage.isHSError()) {
            System.err.println("HS Response RC = 0x" + Integer.toHexString(hardwareServerMessage.getErrorCode()));
            System.err.println("HS Response: " + hardwareServerMessage.toString());
            return null;
        }
        byte[] byArray = hardwareServerMessage.getPayload();
        if (byArray.length < 40 || byArray[22] != 0 || byArray[23] != 0 || (byArray[0] & 0xFF) != 222) {
            System.err.println("FSP error response = " + new HexDump(byArray));
            int n = (byArray[22] & 0xFF) << 8 | byArray[23] & 0xFF;
            return null;
        }
        return byArray;
    }

    private HardwareServerMessage sendAndRecieve(HardwareServerMessage hardwareServerMessage) throws IOException {
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
        return new HardwareServerMessage(this.m_socketInput);
    }

    public static class HypIpConfigInfo {
        public int m_drcIndex;
        public int m_ipAddr;
        public int m_mask;
        public int m_gateway1;
        public int m_gateway2;
        public int m_speed;
        public int m_duplex;
        public int m_state;

        public HypIpConfigInfo(DataInputStream dataInputStream) throws IOException {
            this.m_drcIndex = dataInputStream.readInt();
            this.m_ipAddr = dataInputStream.readInt();
            this.m_mask = dataInputStream.readInt();
            this.m_gateway1 = dataInputStream.readInt();
            this.m_gateway2 = dataInputStream.readInt();
            this.m_speed = dataInputStream.readByte() & 0xFF;
            this.m_duplex = dataInputStream.readByte() & 0xFF;
            this.m_state = dataInputStream.readByte() & 0xFF;
            dataInputStream.readByte();
        }

        public HypIpConfigInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.m_drcIndex = n;
            this.m_ipAddr = n2;
            this.m_mask = n3;
            this.m_gateway1 = n4;
            this.m_gateway2 = n5;
            this.m_speed = n6;
            this.m_duplex = n7;
            this.m_state = n8;
        }

        public void writeToDataOutputStream(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.m_drcIndex);
            dataOutputStream.writeInt(this.m_ipAddr);
            dataOutputStream.writeInt(this.m_mask);
            dataOutputStream.writeInt(this.m_gateway1);
            dataOutputStream.writeInt(this.m_gateway2);
            dataOutputStream.writeByte(this.m_speed);
            dataOutputStream.writeByte(this.m_duplex);
            dataOutputStream.writeByte(this.m_state);
            dataOutputStream.writeByte(0);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DRC,IP,Mask,GW1,GW2,Speed,Duplex,State=0x");
            stringBuffer.append(Integer.toHexString(this.m_drcIndex));
            stringBuffer.append(", " + PIHypIPCfg.IPAddrToString(this.m_ipAddr));
            stringBuffer.append(", " + PIHypIPCfg.IPAddrToString(this.m_mask));
            stringBuffer.append(", " + PIHypIPCfg.IPAddrToString(this.m_gateway1));
            stringBuffer.append(", " + PIHypIPCfg.IPAddrToString(this.m_gateway2));
            switch (this.m_speed) {
                case 0: {
                    stringBuffer.append(", AUTO");
                    break;
                }
                case 1: {
                    stringBuffer.append(", 4");
                    break;
                }
                case 2: {
                    stringBuffer.append(", 10");
                    break;
                }
                case 3: {
                    stringBuffer.append(", 16");
                    break;
                }
                case 4: {
                    stringBuffer.append(", 100");
                    break;
                }
                case 5: {
                    stringBuffer.append(", 1000");
                    break;
                }
                default: {
                    stringBuffer.append(", ERROR");
                }
            }
            switch (this.m_duplex) {
                case 0: {
                    stringBuffer.append(", AUTO");
                    break;
                }
                case 1: {
                    stringBuffer.append(", HALF");
                    break;
                }
                case 2: {
                    stringBuffer.append(", FULL");
                    break;
                }
                default: {
                    stringBuffer.append(", ERROR");
                }
            }
            switch (this.m_state) {
                case 0: {
                    stringBuffer.append(", DOWN");
                    break;
                }
                case 1: {
                    stringBuffer.append(", UP");
                    break;
                }
                case 255: {
                    stringBuffer.append(", UNKNOWN");
                    break;
                }
                default: {
                    stringBuffer.append(", ERROR[" + this.m_state + "]");
                }
            }
            return stringBuffer.toString();
        }
    }
}

